/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal;

import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitRepository;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public abstract class Launcher {
    public static ILaunch launch(GitRepository repo, IProgressMonitor monitor, String ... args) throws CoreException {
        IPath workingDir = null;
        if (repo != null) {
            workingDir = repo.workingDirectory();
        }
        ILaunchConfigurationWorkingCopy config = Launcher.createLaunchConfig(GitExecutable.instance().path().toOSString(), workingDir, args);
        return config.launch("run", monitor);
    }

    private static ILaunchConfigurationWorkingCopy createLaunchConfig(String command, IPath workingDir, String ... args) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType("com.aptana.git.core.launchConfigurationType");
        String name = String.valueOf(Launcher.getLastPortion(command)) + " " + Launcher.join(args, " ");
        name = manager.generateLaunchConfigurationName(name);
        String toolArgs = String.valueOf('\"') + Launcher.join(args, "\" \"") + '\"';
        ILaunchConfigurationWorkingCopy config = configType.newInstance(null, name);
        config.setAttribute("ATTR_LOCATION", command);
        config.setAttribute("ATTR_ARGUMENTS", toolArgs);
        if (workingDir != null) {
            config.setAttribute("ATTR_WORKING_DIRECTORY", workingDir.toOSString());
        }
        config.setAttribute("org.eclipse.debug.core.capture_output", true);
        config.setAttribute("ATTR_SHOW_CONSOLE", true);
        config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        config.setAttribute("process_factory_id", "com.aptana.console.processFactory");
        Map env = GitExecutable.getEnvironment();
        if (!env.isEmpty()) {
            config.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
            config.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        }
        return config;
    }

    private static String getLastPortion(String command) {
        return new Path(command).lastSegment();
    }

    private static String join(String[] commands, String delimiter) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            builder.append(command).append(delimiter);
            ++n2;
        }
        builder.delete(builder.length() - delimiter.length(), builder.length());
        return builder.toString();
    }
}

